# DISCRETE TRAFFIC MODEL ON A ONE-WAY STRAIGHT ROAD
import numpy as np
import matplotlib.pyplot as plt
#---------------------------------------------------------------------------
N=300                                    # number of cars
p_bozo=0.1                               # probability of random braking
n_iter=2000                              # number of temporal iterations
#---------------------------------------------------------------------------
v=np.zeros(N)                            # zero initial speeds for all cars
x=np.zeros(N)                            # car positions
mean_v=np.zeros(n_iter)                  # time series of mean speed
x[0]=1                                   # first car at x=1
for k in range(1,N):                     # initialize car positions
    x[k]=x[k-1]+np.floor(np.random.uniform(3.,14.))

for iterate in range(0,n_iter):          # temporal loop

    for k in range (0,N-1):              # first car loop: update speeds
        dx=x[k+1]-x[k]                   # distance to next car ahead
        if dx < 5:                       # too close: slow down
            v[k]=max(0,v[k]-3)
        if dx > 5:                       # far enough: speed up
            v[k]=min(10,v[k]+1)
        if x[N-1]-x[N-2] <= 10:          # special case: lead car
            v[N-1]=min(10,v[N-1]+1)

    for k in range(0,N):                 # second car loop: braking
        if np.random.random() <= p_bozo: # some bozo slams the brakes
            v[k]=max(0,v[k]-3)

    for k in range(0,N-1):               # third car loop: update positions
        x[k]=min(x[k]+v[k],x[k+1]-1)     # with no-crash safety test
    x[N-1]+=v[N-1]                       # special case: lead car

    mean_v[iterate]=(v.sum())/N
    print("iteration {0}, mean speed {1}.".format(iter,mean_v[iterate]))
# end of temporal loop
plt.plot(range(0,n_iter),mean_v)         # plot mean speed vs iteration
plt.axis([0,n_iter,0.,10.])
plt.xlabel('Iteration')
plt.ylabel('Mean car speed')
plt.show()
# END
