# SLOPE-BASED SANDPILE MODEL IN ONE DIMENSION
import numpy as np
import matplotlib.pyplot as plt
#----------------------------------------------------------------------------
N=101                                      # Lattice size
E=0.1                                      # Peak forcing increment
critical_slope=5.                          # critical slope
n_iter=200000                              # Number of temporal iterations
#----------------------------------------------------------------------------
sand=np.zeros(N)                           # Lattice, initially empty
tsav=np.zeros(n_iter)                      # Avalanche time series
mass=np.zeros(n_iter)                      # Sandpile mass time series

for iterate in range(0,n_iter):            # Temporal iteration
    move=np.zeros(N)                       # Initialize diplaced sand array

    for j in range(0,N-1):                 # Loop over lattice
        slope=abs(sand[j+1]-sand[j])       # Eq (5.3): slope between j,j+1
        if slope >= critical_slope:        # Pair j,j+1 is unstable
            avrg=(sand[j]+sand[j+1])/2.
            move[j]  +=(avrg-sand[j]  )/2. # Eq (5.4) sand moved to/from j
            move[j+1]+=(avrg-sand[j+1])/2. # Eq (5.4) sand moved to/from j+1
            tsav[iterate]+=slope/4.        # Eq (5.7) cumulate displaced mass
    # end of lattice loop

    if tsav[iterate] > 0:                  # At least one node avalanched
        sand+=move                         # Transfer sand
    else:                                  # No avalanche; drive lattice
        j=np.random.random_integers(0,N-1) # Pick random node
        sand[j]+=np.random.uniform(0,E)    # Eq (5.2): add sand increment

    sand[N-1]=0.                           # Eq (5.8): boundary condition
    mass[iterate]=np.sum(sand)             # Sandpile mass at this iteration
#   print("{0}, mass {1}.".format(iterate,mass[iterate]))
# End of temporal iteration

# Now plot a simpler version of Figure 5.4
plt.subplot(2,1,1)                         # Set up first plot (top)
plt.plot(range(0,n_iter),mass)             # Sandpile mass vs iteration
plt.ylabel('Sandpile mass')
plt.subplot(2,1,2)                         # Set up second plot (bottom)
plt.plot(range(0,n_iter),tsav)             # Displaced mass vs iteration
plt.ylabel('Displaced mass')            
plt.xlabel('iteration')
plt.show()
# END
