# OLAMI-CHRISTENSEN-FEDER 2D LATTICE MODEL FOR EARTHQUAKES
import numpy as np
import matplotlib.pyplot as plt
#------------------------------------------------------------------------
N       =64                                 # lattice size
f_thresh=5.                                 # force threshold
delta_f =1.e-4                              # forcing amplitude
alpha   =0.15                               # conservation parameter
n_iter  =100000                             # number of temporal iterations 
#------------------------------------------------------------------------
dx=np.array([-1,0,1,0])                     # template arrays
dy=np.array([0,-1,0,1])                     # template arrays
force=np.zeros([N+2,N+2])                   # force array
toppling=np.zeros(n_iter,dtype='int')       # toppling time series
totalf=np.zeros(n_iter,dtype='int')         # total force time series
for i in range(1,N+1):
    for j in range(1,N+1):
        force[i,j]=f_thresh*(np.random.uniform()) # random initial force 

for iterate in range(0,n_iter):             # temporal iteration
    move =np.zeros([N+2,N+2])               # reset evolution array
    # scan lattice to flag which nodes must redistribute and reset to zero
    for i in range(1,N+1):
        for j in range(1,N+1):
            if force[i,j] >= f_thresh:      # node i,j is unstable
                move[i,j]-=force[i,j]                   # Eq (8.13): reset
                move[i+dx[:],j+dy[:]]+=alpha*force[i,j] # Eq (8.14): distribute
                toppling[iterate]+=1        # cumulate topplings 
    # end of lattice scan

    if toppling[iterate] > 0:               # avalanche occured
        force+=move                         # update lattice
    else:                                   # no avalanche
        force[:,:]+=delta_f                 # Eq (8.11): drive lattice
  
    totalf[iterate]=force.sum()             # total force on lattice
    if iterate % 10000 == 0: 
        print("{0}, toppl {1}.".format(iterate,toppling[iterate])) 
# end of temporal loop
plt.subplot(2,1,1)
plt.plot(range(0,n_iter),totalf)            # plot total force time series
plt.ylabel('Total force')
plt.subplot(2,1,2)
plt.plot(range(0,n_iter),toppling)          # plot toppling time series
plt.xlabel('Iteration')
plt.ylabel('Toppling nodes')
plt.show()
# END
