# FLOCKING SIMULATION ON THE UNIT SQUARE
import numpy as np
import matplotlib.pyplot as plt
#---------------------------------------------------------------------------
N     =350                          # Number of agents                  
n_iter=1000                         # Number of temporal iterations     
dt    =0.01                         # Time step
r0    =0.005                        # Range of repulsion force           
eps   =0.1                          # Amplitude of repulsion force       
rf    =0.1                          # Range of flocking force            
alpha =1.0                          # Amplitude of flocking force        
v0    =0.0                          # Target speed                       
mu    =10.                          # Amplitude of self-propulsion force 
ramp  =0.5                          # Amplitude of random force          
#---------------------------------------------------------------------------
# The buffer and force functions of Figs. 10.3 and 10.4 should go here
#---------------------------------------------------------------------------
x,y  =np.zeros(N),np.zeros(N)       # Positions of agents
vx,vy=np.zeros(N),np.zeros(N)       # Velocities of agents
fx,fy=np.zeros(N),np.zeros(N)       # Forces on agents
xb =np.zeros([4*N])                 # Define buffer zone arrays
yb =np.zeros([4*N])             
vxb=np.zeros([4*N])
vyb=np.zeros([4*N]) 
for j in range(0,N):                # Initialize positions and velocities
    x[j] =np.random.uniform()       # Random position in unit square       
    y[j] =np.random.uniform()
    vx[j]=np.random.uniform(-1.,1.) # Random velocity components in [-1,1] 
    vy[j]=np.random.uniform(-1.,1.)
  
for iterate in range(0,n_iter):     # Temporal loop          
    # First add replicate agents in buffer around unit square
    nb,xb,yb,vxb,vyb=buffer(max(r0,rf),x,y,vx,vy) 
    # Now calculate acceleration for each real agent
    fx,fy=force(nb,xb,yb,vxb,vyb,x,y,vx,vy) 
    vx+=fx*dt                       # Eqs (10.10) by components
    vy+=fy*dt                       # (remember mass=1)
    x +=vx*dt                     
    y +=vy*dt  
    x =(1.+x) % 1                   # Enforce periodicity in x
    y =(1.+y) % 1                   # Enforce periodicity in y
# End of temporal loop
plt.scatter(x,y)                    # Plot positions of agents
plt.quiver(x,y,vx,vy,headlength=5)  # Plot velocity vectors of agents
plt.axis([0.,1.,0.,1.])
plt.show()
# END
