# PATTERN FORMATION BY THE HODGEPODGE MACHINE ON A 2D LATTICE 
import numpy as np
import matplotlib.pyplot as plt
#--------------------------------------------------------------------------
N =128                                         # Lattice size
AA=255                                         # Activation threshold
a =1.0                                         # Activation parameter
r =5.                                          # Recovery parameter
g =30.                                         # Acceleration parameter
n_iter=423                                     # Number of iterations 
#--------------------------------------------------------------------------
# FUNCTION PERIODIC: enforces periodicity (see Fig D.3)
def periodic(N,grid):          
   grid[1:N+1,0]  =grid[1:N+1,N]               # Horizontal periodicity 
   grid[1:N+1,N+1]=grid[1:N+1,1]
   grid[0,1:N+1]  =grid[N,1:N+1]               # Vertical periodicity 
   grid[N+1,1:N+1]=grid[1,1:N+1]
   grid[0,0],grid[N+1,N+1]=grid[N,N],grid[1,1] # The four corners
   grid[0,N+1],grid[N+1,0]=grid[N,1],grid[1,N]
# END OF FUNCTION PERIODIC 
#--------------------------------------------------------------------------
# MAIN PROGRAM
dx=np.array([-1, 0, 1,1,1,0,-1,-1])            # Template arrays
dy=np.array([-1,-1,-1,0,1,1, 1, 0])
state   =np.zeros([N+2,N+2],dtype='int')       # Lattice array
for i in range(1,N+1):
    for j in range(1,N+1):
        state[i,j]=np.random.random_integers(0,AA)
periodic(N,state)                              # Enforce periodicity
for iterate in range(0,n_iter):
    update=np.zeros([N+2,N+2],dtype='int')     # Lattice update array
    for i in range(1,N+1):                     # Main lattice loop
        for j in range(1,N+1):
            suma,sumr,nsum=0.,0.,1.*state[i,j] # Initialize counters
            for k in range(0,8):               # Loop over nearest-neighbours
                ns=state[i+dx[k],j+dy[k]]
                nsum+=ns                       # Sum all nodes (Eq 11.1)
                if (ns == AA): suma+=1         # Sum activated nodes
                if (ns > 0) and (ns < AA): sumr+=1 # Sum recovering nodes
            if state[i,j] > 0 and state[i,j] < AA: # In recovery phase
                update[i,j]=min([AA,int(nsum/(sumr+1.)+g)]) # Eq (11.3)
            elif state[i,j] == AA:             # Enter rest phase
                update[i,j]= 0    
            elif state[i,j] == 0:              # Enter recovery phase
                update[i,j]=min(AA,int(suma/a+sumr/r))      # Eq (11.2)
# End of main lattice loop
    periodic(N,update)                         # Enforce periodicity
    state=update                               # Synchronous update
# End of temporal iteration
plt.imshow(state,cmap="gray",interpolation="nearest")
plt.show()
# END
