# FORCE FUNCTION: CALCULATE TOTAL FORCE ACTING ON ALL AGENTS 
# Values for r0,eps,rf,alpha,v0,mu,ramp set in calling program
def force(nb,xb,yb,vxb,vyb,x,y,vx,vy):

    for j in range(0,N):                       # Loop over real agents
        repx,repy,flockx,flocky,nflock=0.,0.,0.,0.,0 
        for k in range(0,nb):                  # Loop over agents+replicants  
            d2=(xb[k]-x[j])**2+(yb[k]-y[j])**2 # Squared distance j,k  
            if (d2 <= rf**2) and (j != k):     # k contributes to flocking 
                flockx+=vxb[k]
                flocky+=vyb[k]
                nflock+=1
                if (d2 <= 4.*r0**2):           # k contributes to repulsion  
                    d=np.sqrt(d2) ;            # Distance between j and k
                    repx+=eps*(1.-d/(2.*r0))**1.5 *(x[j]-xb[k])/d # Eq (10.1) 
                    repy+=eps*(1.-d/(2.*r0))**1.5 *(y[j]-yb[k])/d 
        # End of loop over agents and replicants

        normflock=np.sqrt(flockx**2+flocky**2) # Denominator in Eq (10.2)
        if ( nflock == 0 ): normflock=1.       # To avoid 0/0 division
        flockx=alpha*flockx/normflock          # Flocking Eq (10.2)       
        flocky=alpha*flocky/normflock
        vnorm =np.sqrt(vx[j]**2+vy[j]**2)      # Speed of agent j
        fpropx=mu*(v0-vnorm)*(vx[j]/vnorm)     # Self-propulsion Eq (10.4)
        fpropy=mu*(v0-vnorm)*(vy[j]/vnorm) 
        frandx=ramp*np.random.uniform(-1.,1.)  # Random force Eq (10.5) 
        frandy=ramp*np.random.uniform(-1.,1.) 
        fx[j]=(flockx+frandx+fpropx+repx)      # Total force on agent j
        fy[j]=(flocky+frandy+fpropy+repy) 
    # End of loop over real agents

    return fx,fy
#END OF FORCE FUNCTION
