# FUNCTION FINDCLUSTER: TAGS AND PLOTS PERCOLATION CLUSTERS ON A 2D LATTICE
#    lattice is supposed of size NxN with nodal value 1 indicating an
#    occupied node and a value 0 for an empty node
def findcluster(N,lattice):
   dx,dy=np.array([-1,0,1,0]),np.array([0,-1,0,1]) # Template arrays
   size_cluster=np.zeros(N*N/2,dtype='int')        # Cluster size array
   tag_cluster =np.zeros(N*N/2,dtype='int')        # Cluster tag array
   map_cluster =np.zeros([N+2,N+2],dtype='int')    # Cluster map array
   map_cluster[1:N+1,1:N+1]=lattice[:,:]           # Pad lattice with zeros
   n_cluster,iic=0,100                             # Counter, first tag

   for j in range(1,N+1):                          # Outer lattice scan
      for k in range(1,N+1):
         size,add_to_size=0,0                      # Initialize counters

         if map_cluster[j,k] == 1:                 # Initiate new tagging
            map_cluster[j,k]=iic                   # New cluster tag
            size+=1                                # First node of cluster
            add_to_size+=1                        

            while( add_to_size > 0)                # Tagging in progress
               add_to_size=0
               j1,j2=j,min(N,j+size)               # Range of inner scan
               k1,k2=max(1,k-size),min(N,k+size)
               for jj in range(j1,j2+1):           # Inner lattice scan
                  for kk in range(k1,k2+1):
                     if map_cluster[jj,kk] == 1:   # Untagged occupied node 
                        if iic in map_cluster[jj+dx[:],kk+dy[:]]:
                           map_cluster[jj,kk]=iic  # assign tag to node
                           size+=1
                           add_to_size+=1 
            # end of inner lattice scan
            size_cluster[n_cluster]=size           # Size of this cluster
            tag_cluster[n_cluster] =iic            # Tag for this cluster
            print("cluster tag {}, size {}.".format(iic,size)) 
            iic=np.random.random_integers(10,250)  # Set up next tag
            n_cluster+=1                           # Increment counter
         # end of this tagging

   # end of outer lattice scan; display clusters
   plt.imshow(map_cluster,interpolation="nearest") # Display clusters
   plt.show()
   return n_cluster,size_cluster,tag_cluster,map_cluster
# END FUNCTION FINDCLUSTER
