# FOREST-FIRE MODEL ON 2D CARTESIAN LATTICE
import numpy as np
import matplotlib.pyplot as plt
#---------------------------------------------------------------------------
N     =100                                    # Lattice size
p_g   =1.e-3                                  # Growth probability
p_f   =1.e-5                                  # Lightning probability
n_iter=25000                                  # Number of temporal iterations
#---------------------------------------------------------------------------
dx=np.array([-1,0,1,1,1,0,-1,-1])             # Template arrays
dy=np.array([-1,-1,-1,0,1,1,1,0])
grid=np.zeros([N+2,N+2],dtype='int')          # Initialize lattice: no trees
trees=0                                       # Tree counter

for iterate in range(0,n_iter):                # temporal iteration
    update=np.zeros([N+2,N+2],dtype='int')     # evolution array
    burn=0                                     # burning tree counter
    # scan lattice to flag which trees must grow, ignite or vanish
    for i in range(1,N+1):
        for j in range(1,N+1):
            if grid[i,j] == 1:                 # there is a tree on this node
                if 2 in grid[i+dx[:],j+dy[:]]: # 1 or more burning neighbour 
                    update[i,j]=1              # ignite
                    burn+=1
                if np.random.uniform() < p_f:  # lightning strikes (maybe)
                    update[i,j]=1              # ignite
                    burn+=1
            if grid[i,j] == 2:                 # remove trees already burning
                update[i,j]=-2
                trees-=1
            if grid[i,j] == 0:                 # empty node
                if np.random.uniform() < p_g:  # grow tree (maybe)
                    update[i,j]=1
                    trees+=1
   # end of lattice scan

    grid+=update                               # synchronous update of lattice
    print("iteration {0}, trees {1}, burn {2}.".format(iterate,trees,burn))
# end of temporal loop
plt.imshow(grid,interpolation="nearest")       # display final state 
plt.show()
# END
