# EPIDEMIC SPREAD IN A POPULATION OF RANDOM WALKERS ON A LATTICE 
import numpy as np
import matplotlib.pyplot as plt
#---------------------------------------------------------------------------
N       =128                                  # lattice size
M       =4000                                 # number of random walkers
L       =20                                   # lifetime parameter
max_iter=10000                                # maximum number of iterations 
#---------------------------------------------------------------------------
x_step  =np.array([-1,0,1,0])                 # template arrays 
y_step  =np.array([0,-1,0,1])   
x,y     =np.zeros(M),np.zeros(M)              # walker (x,y) coordinates
infect  =np.zeros(M)                          # walker health status 
lifespan=np.zeros(M)                          # time left to live
ts_sick =np.zeros(max_iter)                   # time series of sick walkers
for j in range(M):                            # place walkers on lattice
    x[j]=np.random.random_integers(0,N) 
    y[j]=np.random.random_integers(0,N) 
    lifespan[j]=L
jj=np.random.random_integers(0,M-1)           # infect one random walker
infect[jj]=1
n_sick,n_dead,iterate=1,0,0                   # various counters 

while (n_sick > 0) and (iterate < max_iter):  # temporal iteration
    for j in range(0,M):                      # loop over all walkers
        if infect[j] < 2:                     # this walker is still alive 
            ii=np.random.choice([0,1,2,3])    # pick direction
            x[j]+=x_step[ii]                  # update walker coordinates 
            y[j]+=y_step[ii]
            x[j]=min(N,max(x[j],1))           # bounding walls in x,y
            y[j]=min(N,max(y[j],1))
        if infect[j]==1:                      # this walker is sick
            lifespan[j]-=1                    # the clock ticks...
            if lifespan[j] <= 0:              # this walker dies
                infect[j]=2
                n_sick-=1
                n_dead+=1
            for k in range(0,M):              # check for walkers on node
                if infect[k] == 0 and k != j: # this one is healthy...
                    if x[j]==x[k] and y[j]==y[k]:   # ...and so: infect
                        infect[k]=1 
                        n_sick+=1
    # end of loop over all walkers
    ts_sick[iterate]=n_sick
    iterate+=1
    print("iteration {0}, sick {1}, dead {2}.".format(iterate,n_sick,n_dead)) 
# end of temporal loop
plt.plot(range(0,iterate+10),ts_sick[0:iterate+10])
plt.show()
# END
