# DIFFUSION-LIMITED AGGREGATION ON A CARTESIAN LATTICE
import numpy as np
import matplotlib.pyplot as plt
#---------------------------------------------------------------------------
N        =128                            # Lattice size
max_iter =100000                         # Max number of temporal iterations 
n_walkers=1000                           # Number of random walkers
#---------------------------------------------------------------------------
x_step=np.array([-1,0,1,0])              # Template arrays for random walk
y_step=np.array([0,-1,0,1])              
dx    =np.array([-1,0,1,0,-1,1,1,-1])    # Template arrays for sticking 
dy    =np.array([0,-1,0,1,-1,-1,1,1])
grid  =np.zeros([N+2,N+2],dtype='int')   # Lattice array
x     =np.zeros(n_walkers,dtype='int')   # Walker x-coordinate in nodal unit
y     =np.zeros(n_walkers,dtype='int')   # Walker y-coordinate in nodal unit
status=np.ones(n_walkers,dtype='int')    # Walker status array: all mobile
for i in range(0,n_walkers):             # Place walkers on lattice
    x[i]=np.random.random_integers(0,N-1)
    y[i]=np.random.random_integers(0,N-1)
    grid[x[i],y[i]]=1
grid[N//2,N//2]=2                        # Introduce sticky central node

iteration,n_glued=0,0                    # Counters
while (n_glued < n_walkers) and (iteration < max_iter): 
    for i in range(0,n_walkers):         # Loop over walkers
        if status[i] == 1:               # This walker is still mobile 
            ii=np.random.choice([0,1,2,3])        # Pick direction
            x_new=x[i]+x_step[ii]        # New position on lattice
            y_new=y[i]+y_step[ii]
            x_new=(N+x_new) % N          # Periodic boundaries in x,y
            y_new=(N+y_new) % N 
            grid[x_new,y_new]=1          # Update lattice
            grid[x[i],y[i]]=0
            x[i],y[i]=x_new,y_new        # Move walker 
            if 2 in grid[x[i]+dx[:],y[i]+dy[:]]: # Check for sticky neighbour
                grid[x[i],y[i]]=2        # Assign sticky status to walker
                status[i]=2
                n_glued+=1
        # End of work on this mobile walker
    # End of loop over all walkers
    # Graphics command displaying positions of glued walkers could go here
    iteration+=1
    print("iteration {0}, glued walkers {1}.".format(iteration,n_glued)) 
# End of temporal loop
plt.imshow(grid,interpolation="nearest") # display aggregate as pixel image
plt.show()
# END
