# 2D 2-STATES CELULAR AUTOMATON ON TRIANGULAR LATTICE
import numpy as np
import matplotlib.pyplot as plt 
#---------------------------------------------------------------------------
N=24                                        # Size of 2D CA
n_iter=10                                   # Number of iterations
n_neighbour=6                               # Number of connected neighbours
#---------------------------------------------------------------------------
dx=np.array([ 1, 0,1,-1,0,-1])              # nearest neighbour template
dy=np.array([-1,-1,0, 1,1, 0])
image=np.zeros([N,N],dtype='int')           # Initialize lattice to white...
image[N//2,N//2]=1                          # ...except central node to black
plt.scatter(N//2,N//2)                      # Set up plot, with central node
plt.axis([0,N,0,N])
plt.axes().set_aspect('equal')
for iteration in range(1,n_iter):           # Iteration loop

    update=np.zeros([N,N],dtype='int')      # Set/reset evolution array
  
    for i in range(1,N-1):                  # Lattice loops
        for j in range(1,N-1): 
            cumul=0
            for k in range(0,n_neighbour):  # Loop over nearest-neighbour
                cumul+=image[i+dx[k],j+dy[k]]
            if image[i,j]==0 and cumul==1:  # Only one active neighbour
                update[i,j]=1               # Activate node
                plt.scatter(j+(i-N//2)/2.,N//2+0.866*(i-N//2)) # Plot node
    # End of lattice loops

    image+=update                           # Synchronous update of CA

# End of iteration loop
plt.show()                                  # Display structure
# END
