# 1D 2-STATES CELLULAR AUTOMATON
import numpy as np
import matplotlib.pyplot as plt
#-------------------------------------------------------------------------
N=129                                        # Size of 1D CA
n_iter=64                                    # Number of iterations
#-------------------------------------------------------------------------
image=np.zeros([n_iter,N],dtype='int')       # Initialize lattice to white
image[0,N/2]=1                               # But set central node to black

for iterate in range(1,n_iter):              # Iteration loop

    for j in range(1,N-1):                   # Lattice loop
        if image[iterate-1,j+1]+image[iterate-1,j-1] == 1:  # Third rule
            image[iterate,j]=1               # Turn node black
    # End of lattice loop

    image[iterate,0]=image[iterate,N-2]      # Enforce periodicity
    image[iterate,N-1]=image[iterate,1]
# End of iteration loop

plt.imshow(image,interpolation="nearest")    # Display structure
plt.show()
# END

