# BUFFER FUNCTION: INTRODUCE REPLICATE AGENTS OUTSIDE OF UNIT SQUARE,
# IN A SQUARE BUFFER EXTENDING OUTWARD BY A DISTANCE rb
def buffer(rb,x,y,vx,vy):
    xb[0:N],yb[0:N]  =x[0:N],y[0:N]             # Initialize buffer arrays
    vxb[0:N],vyb[0:N]=vx[0:N],vy[0:N]
    nb=N-1                                      # Already have N real agents
    for k in range(0,N):                        # Add replicants to buffer  
        if ( x[k] <= rb ):                      # Close to left 
            nb+=1
            xb[nb]=x[k]+1.
            yb[nb],vxb[nb],vyb[nb]=y[k],vx[k],vy[k]
        if ( x[k] >= 1.-rb):                    # Close to right 
             nb+=1
             xb[nb]=x[k]-1.
             yb[nb],vxb[nb],vyb[nb]=y[k],vx[k],vy[k]
        if ( y[k] <= rb ):                      # Close to bottom 
             nb+=1
             yb[nb]=y[k]+1.
             xb[nb],vxb[nb],vyb[nb]=x[k],vx[k],vy[k]
        if ( y[k] >= 1.-rb ):                   # Close to top 
             nb+= 1
             yb[nb]=y[k]-1.
             xb[nb],vxb[nb],vyb[nb]=x[k],vx[k],vy[k]
        if ( x[k] <= rb and y[k] <= rb ):       # Close to bottom left
             nb+= 1
             xb[nb],yb[nb]=x[k]+1.,y[k]+1.
             vxb[nb],vyb[nb]=vx[k],vy[k]
        if ( x[k] >= 1.-rb and y[k] <= rb ):    # Close to bottom right
             nb+= 1
             xb[nb],yb[nb]=x[k]-1.,y[k]+1.
             vxb[nb],vyb[nb]=vx[k],vy[k]
        if ( x[k] <= rb and y[k] >= 1.-rb ):    # Close to top left 
             nb+= 1
             xb[nb],yb[nb]=x[k]+1.,y[k]-1.
             vxb[nb],vyb[nb]=vx[k],vy[k]
        if ( x[k] >= 1.-rb and y[k] >= 1.-rb ): # Close to top right 
             nb+= 1
             xb[nb],yb[nb]=x[k]-1.,y[k]-1.
             vxb[nb],vyb[nb]=vx[k],vy[k]
    # End of buffer loop  
    return nb,xb,yb,vxb,vyb                     # Total real+replicate agents
# END OF FUNCTION BUFFER 
