# HIGHWAY BUILDING BY LANGTON'S ANT
import numpy as np
import matplotlib.pyplot as plt
#--------------------------------------------------------------------------
N     =300                            # Lattice size
n_iter=20000                          # Number of temporal iterations 
#--------------------------------------------------------------------------
x_step=np.array([0,-1,0,1])           # Template arrays for steps
y_step=np.array([1,0,-1,0])
image=np.zeros([N,N],dtype='int')     # Initialize lattice array, all white
ix=N//4                               # Ant's starting position in x
iy=N//4                               # Ant's starting position in y
direction=1                           # Ant's starting direction, North

for iteration in range(0,n_iter):     # Temporal loop

    ix+=x_step[direction]             # Ant moves
    iy+=y_step[direction]      
    ix=(N+ix) % N                     # Enforce periodicity in x
    iy=(N+iy) % N                     # Enforce periodicity in y

    if image[iy,ix] == 0:             # On a white node
        update=1                      # Paint it black...
        direction+=1                  # ...and turn right...
        direction=direction % 4       # ...but stay within step array
    else:                             # On a black node
        update=-1                     # Paint it white...
        direction-=1                  # ...and turn left...
        direction=(4+direction) % 4   # ...but stay within step array

    image[iy,ix]+=update
# End of temporal loop
plt.imshow(image,interpolation="nearest")
plt.show()                            # Display final structure
# END
